/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.tile;

import committee.nova.mods.avaritia.api.common.item.BaseItemStackHandler;
import committee.nova.mods.avaritia.api.common.tile.BaseInventoryTileEntity;
import committee.nova.mods.avaritia.common.crafting.recipe.CompressorRecipe;
import committee.nova.mods.avaritia.common.menu.CompressorMenu;
import committee.nova.mods.avaritia.init.registry.ModRecipeTypes;
import committee.nova.mods.avaritia.init.registry.ModTileEntities;
import committee.nova.mods.avaritia.util.ItemUtils;
import committee.nova.mods.avaritia.util.lang.Localizable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompressorTile
extends BaseInventoryTileEntity
implements MenuProvider {
    private final BaseItemStackHandler inventory;
    private final BaseItemStackHandler recipeInventory;
    private CompressorRecipe recipe;
    private ItemStack materialStack = ItemStack.f_41583_;
    private int materialCount;
    private int progress;
    private boolean ejecting = false;
    private final SimpleContainerData data = new SimpleContainerData(1);

    public CompressorTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTileEntities.compressor_tile.get(), pos, state);
        this.inventory = CompressorTile.createInventoryHandler(null);
        this.recipeInventory = new BaseItemStackHandler(1);
    }

    public static BaseItemStackHandler createInventoryHandler(Runnable onContentsChanged) {
        BaseItemStackHandler inventory = new BaseItemStackHandler(2, onContentsChanged);
        inventory.setOutputSlots(0);
        inventory.setSlotValidator((slot, stack) -> slot == 1);
        return inventory;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, CompressorTile tile) {
        ItemStack output = tile.inventory.getStackInSlot(0);
        ItemStack input = tile.inventory.getStackInSlot(1);
        tile.recipeInventory.setStackInSlot(0, tile.materialStack);
        if (tile.recipe == null || !tile.recipe.matches((IItemHandler)tile.recipeInventory)) {
            tile.recipe = level.m_7465_().m_44015_((RecipeType)ModRecipeTypes.COMPRESSOR_RECIPE.get(), tile.recipeInventory.toIInventory(), level).orElse(null);
        }
        if (!level.m_5776_()) {
            int addCount;
            if (!input.m_41619_()) {
                if (tile.materialStack.m_41619_() || tile.materialCount <= 0) {
                    tile.materialStack = input.m_41777_();
                    tile.setChangedFast();
                }
                if (tile.recipe != null && tile.materialCount < tile.recipe.getInputCount() && ItemUtils.areStacksSameType(input, tile.materialStack)) {
                    int consumeAmount = input.m_41613_();
                    consumeAmount = Math.min(consumeAmount, tile.recipe.getInputCount() - tile.materialCount);
                    input.m_41774_(consumeAmount);
                    tile.materialCount += consumeAmount;
                    tile.setChangedFast();
                }
            }
            if (tile.recipe != null && tile.materialCount >= tile.recipe.getInputCount()) {
                ItemStack result;
                ++tile.progress;
                tile.data.m_8050_(0, tile.progress);
                if (tile.progress >= tile.recipe.getTimeRequire() && ItemUtils.canCombineStacks(result = tile.recipe.assemble((IItemHandler)tile.inventory), output)) {
                    tile.updateResult(result);
                    tile.progress = 0;
                    tile.materialCount -= tile.recipe.getInputCount();
                    if (tile.materialCount <= 0) {
                        tile.materialStack = ItemStack.f_41583_;
                    }
                    tile.setChangedFast();
                }
            }
            if (tile.ejecting && tile.materialCount > 0 && !tile.materialStack.m_41619_() && (output.m_41619_() || ItemUtils.areStacksSameType(tile.materialStack, output)) && (addCount = Math.min(tile.materialCount, tile.materialStack.m_41741_() - output.m_41613_())) > 0) {
                ItemStack toAdd = ItemUtils.withSize(tile.materialStack, addCount, false);
                tile.updateResult(toAdd);
                tile.materialCount -= addCount;
                if (tile.materialCount < 1) {
                    tile.materialStack = ItemStack.f_41583_;
                    tile.ejecting = false;
                }
                if (tile.progress > 0) {
                    tile.progress = 0;
                }
                tile.setChangedFast();
            }
        }
        tile.dispatchIfChanged();
    }

    @Override
    @NotNull
    public BaseItemStackHandler getInventory() {
        return this.inventory;
    }

    @Override
    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        this.materialCount = tag.m_128451_("MaterialCount");
        this.materialStack = ItemStack.m_41712_((CompoundTag)tag.m_128469_("MaterialStack"));
        this.progress = tag.m_128451_("Progress");
        this.ejecting = tag.m_128471_("Ejecting");
    }

    @Override
    public void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("MaterialCount", this.materialCount);
        tag.m_128365_("MaterialStack", (Tag)this.materialStack.serializeNBT());
        tag.m_128405_("Progress", this.progress);
        tag.m_128379_("Ejecting", this.ejecting);
    }

    @NotNull
    public Component m_5446_() {
        return Localizable.of("container.compressor").build();
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, @NotNull Inventory playerInventory, @NotNull Player player) {
        return CompressorMenu.create(windowId, playerInventory, this.inventory, this.m_58899_());
    }

    public ItemStack getMaterialStack() {
        return this.materialStack;
    }

    public boolean hasMaterialStack() {
        return !this.materialStack.m_41619_();
    }

    public int getMaterialCount() {
        return this.materialCount;
    }

    public boolean isEjecting() {
        return this.ejecting;
    }

    public void toggleEjecting() {
        if (this.materialCount > 0) {
            this.ejecting = !this.ejecting;
            this.setChangedAndDispatch();
        }
    }

    public int getProgress() {
        return this.progress;
    }

    public boolean hasRecipe() {
        return this.recipe != null;
    }

    public CompressorRecipe getActiveRecipe() {
        return this.recipe;
    }

    public int getMaterialsRequired() {
        if (this.hasRecipe()) {
            return this.recipe.getInputCount();
        }
        return 0;
    }

    public int getTimeRequired() {
        if (this.hasRecipe()) {
            return this.recipe.getTimeRequire();
        }
        return 0;
    }

    private void updateResult(ItemStack stack) {
        ItemStack result = this.inventory.getStackInSlot(0);
        if (result.m_41619_()) {
            this.inventory.setStackInSlot(0, stack);
        } else {
            this.inventory.setStackInSlot(0, ItemUtils.grow(result, stack.m_41613_()));
        }
    }
}

